local key = ModPath .. '	' .. RequiredScript
if _G[key] then return else _G[key] = true end

Iter.navlengths = {
	e_nl_10m_turn_l_2m = Vector3(-188.552, 1052.47, -3.23807), -- 1069
	e_nl_10m_turn_r_2m = Vector3(174.631, 1069.4, -1.32419), -- 1083
	e_nl_4m_long_2m_dwn = Vector3(44.5203, 469.154, -197.693), -- 511
	e_nl_actionjump_2m_forward = Vector3(306.574, 444.901, -44.3673), -- 542
	e_nl_actionjump_2m_forward_var2 = Vector3(-61.4592, 623.736, 54.7378), -- 629
	e_nl_boat_climb_to_boat = Vector3(-40.9316, 254.337, 414.303), -- 487
	e_nl_button_slide_under = Vector3(29.6018, 468.052, -2.0524), -- 468
	e_nl_climb_left_door_frames_up_4m = Vector3(19.0752, 29.8198, 402.909), -- 404
	e_nl_climb_over_2m = Vector3(-7.95361, 133, 0.361206), -- 133
	e_nl_climb_over_3m = Vector3(39.3374, 263.095, 0.737146), -- 266
	e_nl_climb_right_door_frames_up_4m = Vector3(-15.5381, 36.9543, 412.433), -- 414
	e_nl_climb_up_2_2m = Vector3(-2.14429, 120.44, 215.905), -- 247
	e_nl_climb_up_3_15m = Vector3(30.0876, 168.727, 316.629), -- 360
	e_nl_climb_up_3_5m = Vector3(8.45044, 190.15, 348.218), -- 396
	e_nl_climb_up_4_75m = Vector3(5.3855, 112.479, 469.765), -- 483
	e_nl_clk_over_1_8m = Vector3(-19.2151, 188.17, 27.3984), -- 191
	e_nl_crawl_3_5m = Vector3(36.3601, 435.669, -1.84626), -- 437
	e_nl_cs_dwn_back = Vector3(75.5208, 44.2524, -442.93), -- 451
	e_nl_cs_dwn_front = Vector3(74.79, 44.3887, -393.89), -- 403
	e_nl_cs_dwn_sewer = Vector3(80.4004, 43.8333, -569.424), -- 576
	e_nl_cs_jump_desk = Vector3(-7.58179, 199.423, 15.5867), -- 200
	e_nl_cs_jump_window = Vector3(30.3335, 299.866, -11.4673), -- 301
	e_nl_cs_up_8m_ladder = Vector3(28.4624, 149.773, 791.908), -- 806
	e_nl_cs_up_back_ladder = Vector3(18.5474, 189.321, 416.42), -- 457
	e_nl_cs_up_front_ladder = Vector3(-11.6567, 180.237, 376.46), -- 417
	e_nl_cs_up_long_ladder = Vector3(-26.3733, 188.669, 540.82), -- 573
	e_nl_cs_up_sewer_ladder = Vector3(17.4238, 149.034, 572.919), -- 592
	e_nl_cs_up_short_ladder = Vector3(19.0542, 191.291, 97.6422), -- 215
	e_nl_dah_climb_to_roof = Vector3(6.68335, 178.081, 948.532), -- 965
	e_nl_dah_climb_up = Vector3(32.5786, 424.438, 396.288), -- 581
	e_nl_dah_climd_down_elevator = Vector3(12.5398, 25.7729, -398.565), -- 399
	e_nl_dah_climd_up_elevator = Vector3(9.43872, 0.420654, 396.126), -- 396
	e_nl_dah_climd_up_window_left = Vector3(3.0105, 98.3618, 399.912), -- 411
	e_nl_dah_climd_up_window_right = Vector3(6.83057, 87.146, 399.02), -- 408
	e_nl_dah_down_roof_hi = Vector3(-13.0823, 203.987, -403.284), -- 452
	e_nl_dah_down_roof_rapel = Vector3(-62.2129, 256.287, -956.497), -- 992
	e_nl_dah_down_window_swing = Vector3(-54.7456, -7.76392, -398.053), -- 401
	e_nl_dah_jump_climd_up_left = Vector3(-123.279, 229.575, 505.61), -- 568
	e_nl_dah_jump_climd_up_right = Vector3(87.4714, 238.292, 508.884), -- 568
	e_nl_dah_jump_down = Vector3(57.7378, 430.755, -395.571), -- 587
	e_nl_dah_up_roof_hi = Vector3(-4.77734, -51.3381, 404.371), -- 407
	e_nl_dah_up_roof_low = Vector3(20.4446, -41.2224, 409.965), -- 412
	e_nl_door_open_hack_code = Vector3(-45.2578, 221.904, 0.720292), -- 226
	e_nl_down_10_3m = Vector3(-77.2871, 251.051, -1024.92), -- 1058
	e_nl_down_10m_cliff = Vector3(19.8579, 701.543, -1015.53), -- 1234
	e_nl_down_10m_rappel = Vector3(28.3501, 319.839, -1001.84), -- 1052
	e_nl_down_12m = Vector3(-38.9106, 201.784, -1197.26), -- 1214
	e_nl_down_12m_var2 = Vector3(16.126, 298.555, -1212.74), -- 1249
	e_nl_down_13m = Vector3(9.50342, 353.861, -1313.36), -- 1360
	e_nl_down_19m = Vector3(-203.376, 892.103, -1817.48), -- 2034
	e_nl_down_1_25m = Vector3(16.4185, 127.683, -125.354), -- 179
	e_nl_down_1_5m = Vector3(16.4385, 137.646, -150.409), -- 204
	e_nl_down_1_75m = Vector3(5.94385, 134.489, -175.394), -- 221
	e_nl_down_1m = Vector3(4.66943, 113.229, -100.804), -- 151
	e_nl_down_2_75m = Vector3(-6.69922, 111.779, -275.305), -- 297
	e_nl_down_2_7_fwd_2m = Vector3(3.51685, 288.431, -270.856), -- 395
	e_nl_down_2m = Vector3(6.27637, 134.669, -200.389), -- 241
	e_nl_down_3_35m = Vector3(4.18213, 115.681, -337.954), -- 357
	e_nl_down_3m = Vector3(14.2039, 145.588, -300.525), -- 334
	e_nl_down_4_1m_swing_in = Vector3(-69.5967, -131.979, -422.139), -- 447
	e_nl_down_4_25m = Vector3(-46.0042, 189.778, -425.536), -- 468
	e_nl_down_4_75m_swing = Vector3(-58.4578, -93.8586, -484.14), -- 496
	e_nl_down_4_fwd_4m = Vector3(0.351807, 972.663, -401.111), -- 1052
	e_nl_down_4m = Vector3(-46.1641, 190.043, -400.542), -- 445
	e_nl_down_4m_jump = Vector3(-11.8169, 129.591, -403.355), -- 423
	e_nl_down_4m_roll = Vector3(-35.4629, 551.521, -496.278), -- 742
	e_nl_down_4m_swing_in = Vector3(-69.3259, -3.28027, -409.837), -- 415
	e_nl_down_4m_swing_in_var2 = Vector3(-69.3293, -3.10791, -409.821), -- 415
	e_nl_down_4m_var2 = Vector3(0.741699, 348.174, -414.374), -- 541
	e_nl_down_4m_var3 = Vector3(-15.9705, 176.126, -403.529), -- 440
	e_nl_down_5_3m = Vector3(-46.0632, 226.604, -530.756), -- 578
	e_nl_down_5_5m = Vector3(-45.7908, 204.013, -550.679), -- 589
	e_nl_down_5_5m_var2 = Vector3(37.9619, 128.157, -549.966), -- 565
	e_nl_down_5m = Vector3(-45.5989, 203.775, -500.686), -- 542
	e_nl_down_5m_swing_in = Vector3(-67.0698, -79.8887, -496.65), -- 507
	e_nl_down_5m_var2 = Vector3(-1.04492, 148.125, -505.104), -- 526
	e_nl_down_5m_var3 = Vector3(1.86548, 335.986, -484.745), -- 589
	e_nl_down_5m_var4 = Vector3(-9.65259, 139.76, -503.145), -- 522
	e_nl_down_6_3m_cliff = Vector3(3.64624, 565.989, -631.364), -- 847
	e_nl_down_6_5m = Vector3(-3.9165, 502.883, -666.792), -- 835
	e_nl_down_6_5m_var2 = Vector3(-30.7908, 500.512, -674.301), -- 840
	e_nl_down_6m = Vector3(-81.5276, 237.938, -602.815), -- 653
	e_nl_down_6m_swing_in = Vector3(-66.9563, -78.4968, -626.617), -- 635
	e_nl_down_6m_swing_in_var2 = Vector3(-68.8521, -12.1108, -604.555), -- 608
	e_nl_down_6m_var3 = Vector3(-11.5898, 148.181, -597.788), -- 615
	e_nl_down_7_3m_cliff = Vector3(7.75098, 611.262, -734.388), -- 955
	e_nl_down_7_6m_cliff = Vector3(7.75439, 611.225, -759.387), -- 974
	e_nl_down_7_75m = Vector3(-81.7532, 237.14, -772.208), -- 811
	e_nl_down_7m = Vector3(-45.6489, 203.791, -700.677), -- 731
	e_nl_down_7m_rappel = Vector3(-85.6587, 326.139, -685.593), -- 764
	e_nl_down_7m_swing_in = Vector3(-60.6846, 23.2905, -701.305), -- 704
	e_nl_down_8_5m_rappel = Vector3(-82.2795, 246.7, -854.392), -- 893
	e_nl_down_8m = Vector3(-45.886, 213.458, -800.716), -- 829
	e_nl_down_8m_swing_in = Vector3(-66.2283, -97.3586, -798.523), -- 807
	e_nl_down_8m_var2 = Vector3(2.90649, 677.785, -864.832), -- 1098
	e_nl_down_8m_var3 = Vector3(-81.8108, 237.001, -815.124), -- 852
	e_nl_down_9_3m_rappel = Vector3(13.0229, 376.485, -929.556), -- 1002
	e_nl_down_9m_swing_in = Vector3(-65.8357, -107.221, -901.83), -- 910
	e_nl_down_elevator = Vector3(-69.7224, 702.794, -701.629), -- 995
	e_nl_down_elevator_shaft = Vector3(-37.5623, 214.161, -388.15), -- 444
	e_nl_down_elevator_var2 = Vector3(1.8667, 428.837, -199.862), -- 473
	e_nl_down_rocks_10m = Vector3(30.6057, 480.354, -989.903), -- 1100
	e_nl_down_rocks_6_5m = Vector3(155.165, 437.695, -648.092), -- 797
	e_nl_down_rocks_8m = Vector3(40.8069, 459.49, -742.207), -- 873
	e_nl_down_stairs_4m = Vector3(-12.3645, 773.279, -400.94), -- 871
	e_nl_down_thermite_hole = Vector3(-40.2393, 40.0132, -401.664), -- 405
	e_nl_dwn_0_5m_window_in = Vector3(22.9663, 215.321, -30.1583), -- 218
	e_nl_dwn_0_7m = Vector3(-6.84692, 190.768, -80.9936), -- 207
	e_nl_dwn_11m = Vector3(-105.41, 213.923, -1105.79), -- 1131
	e_nl_dwn_3_5m = Vector3(-11.2949, 174.6, -345.728), -- 387
	e_nl_dwn_3_5m_slide_cliff = Vector3(-193.103, 362.647, -329.205), -- 526
	e_nl_dwn_3_5m_var2 = Vector3(-6.50269, 436.931, -340.721), -- 554
	e_nl_dwn_3_75m = Vector3(-10.2087, 160.414, -389.516), -- 421
	e_nl_dwn_4_4m_hang = Vector3(-0.432861, 56.8433, -434.354), -- 438
	e_nl_dwn_4_4m_jump = Vector3(13.8367, 185.969, -451.257), -- 488
	e_nl_dwn_4_5m_slide_cliff = Vector3(-208.284, 325.797, -459.381), -- 600
	e_nl_dwn_4_75m = Vector3(-7.74292, 129.736, -472.667), -- 490
	e_nl_dwn_5_6m = Vector3(3.29492, 166.235, -558.587), -- 582
	e_nl_dwn_5_9m = Vector3(-47.0278, 199.041, -592.133), -- 626
	e_nl_dwn_8_7m = Vector3(-75.3308, 248.684, -867.884), -- 905
	e_nl_dwn_jump_4_5m = Vector3(-7.67627, 129.816, -450.48), -- 468
	e_nl_dwn_jump_5_25m = Vector3(-8.13623, 129.78, -525.616), -- 541
	e_nl_dwn_repel_11_25m = Vector3(0.587402, 209.619, -1129.23), -- 1148
	e_nl_enter_wall_hole = Vector3(-12.053, 172.216, -0.289608), -- 172
	e_nl_fwd_1_5_up_1_5m = Vector3(30.6965, 310.892, 148.093), -- 345
	e_nl_fwd_2m = Vector3(2.33301, 245.306, -0.2865), -- 245
	e_nl_fwd_4_up_1_dwn_4_1m = Vector3(-51.7322, 955.794, -315.588), -- 1007
	e_nl_fwd_4m = Vector3(-18.6018, 371.657, -1.07369), -- 372
	e_nl_jump_2_35m_fwd_2m_down = Vector3(29.6953, 287.802, -202.751), -- 353
	e_nl_jump_2m_long = Vector3(44.9282, 270.993, 0.995026), -- 274
	e_nl_jump_4m_long = Vector3(44.4834, 468.43, 1.71397), -- 470
	e_nl_jump_4m_long_5m_down = Vector3(20.9763, 682.248, -497.828), -- 844
	e_nl_jump_4m_long_5m_down_roll = Vector3(-29.575, 866.134, -495.072), -- 998
	e_nl_jump_5_25m_fwd_2m_down = Vector3(60.0308, 624.577, -197.124), -- 657
	e_nl_jump_5_25m_fwd_2m_down_roll = Vector3(104.991, 891.386, -202.862), -- 920
	e_nl_jump_5m_long = Vector3(0.0161133, 515.795, -3.38817), -- 515
	e_nl_jump_climb_through_barbwire = Vector3(17.7341, 467.288, 377.498), -- 600
	e_nl_jump_climb_through_barbwire_var2 = Vector3(63.4448, 458.47, 385.456), -- 602
	e_nl_jump_down_2_5m = Vector3(4.34473, 159.035, -250.451), -- 296
	e_nl_jump_dwn_1_4m_fwd_2_35m = Vector3(29.7432, 287.686, -146.2), -- 324
	e_nl_jump_dwn_3m_fwd_7m_dwn_0_5m = Vector3(772.994, 114.705, -405.078), -- 880
	e_nl_jump_fwd_2m_climb_up_2m = Vector3(35.3674, 438.202, 198.593), -- 482
	e_nl_jump_fwd_5m_down_3m = Vector3(-15.9353, 546.096, -293.258), -- 620
	e_nl_jump_over_0_5m = Vector3(26.2522, 281.36, -1.71511), -- 282
	e_nl_jump_over_1m_shoot = Vector3(2.198, 165.652, -0.492554), -- 165
	e_nl_jump_over_1m_var1 = Vector3(11.863, 196.443, -0.640571), -- 196
	e_nl_jump_over_1m_var2 = Vector3(13.6023, 140.514, 34.2698), -- 145
	e_nl_jump_over_2_5m = Vector3(0, 173.388, 1.92281), -- 173
	e_nl_kick_enter = Vector3(-9.49805, 271.289, -0.806952), -- 271
	e_nl_kick_enter_special = Vector3(-18.4905, 280.735, 77.9628), -- 291
	e_nl_ladder_dwn_16m = Vector3(-45.4863, 151.348, -1604.17), -- 1611
	e_nl_ladder_up_16m = Vector3(94.6809, 75.0635, 1598.72), -- 1603
	e_nl_ladder_up_3m = Vector3(6.66528, 141.356, 285.335), -- 318
	e_nl_ladder_up_4_4m = Vector3(22.4253, 196.057, 444.174), -- 486
	e_nl_open_door = Vector3(19.7954, 133.447, -0.59947), -- 134
	e_nl_over_1_15m = Vector3(20.0039, 348.102, -1.40753), -- 348
	e_nl_over_1_3m = Vector3(0.887939, 196.34, -0.771179), -- 196
	e_nl_over_1_5m = Vector3(0.355713, 265.94, -0.771767), -- 265
	e_nl_over_1_5m_dwn_8m = Vector3(-3.0979, 334.117, -798.951), -- 866
	e_nl_over_1_5m_var2 = Vector3(0.0500488, 177.067, 28.8888), -- 179
	e_nl_over_1_7m_dwn_8m = Vector3(-2.77271, 333.143, -800.287), -- 866
	e_nl_over_1_9m = Vector3(-32.9045, 268.714, -0.355885), -- 270
	e_nl_over_1m_dwn_10_5m = Vector3(4.38965, 293.934, -1078.23), -- 1117
	e_nl_over_1m_dwn_11_5m = Vector3(4.5769, 294.577, -1164.39), -- 1201
	e_nl_over_1m_dwn_11m = Vector3(4.48853, 294.869, -1119.19), -- 1157
	e_nl_over_1m_dwn_12m = Vector3(4.67822, 293.904, -1218.06), -- 1253
	e_nl_over_1m_dwn_13m = Vector3(-47.2314, 294.514, -1300.37), -- 1334
	e_nl_over_1m_dwn_22m_rapel = Vector3(-113.087, 288.38, -2109.62), -- 2132
	e_nl_over_1m_dwn_5_5m = Vector3(-44.136, 218.442, -450.083), -- 502
	e_nl_over_1m_dwn_5_5m_roll = Vector3(-44.1348, 218.423, -460.246), -- 511
	e_nl_over_1m_dwn_5m = Vector3(-44.1372, 218.482, -427.713), -- 482
	e_nl_over_1m_dwn_5m_roll = Vector3(-80.032, 508.429, -430.89), -- 671
	e_nl_over_1m_dwn_6m = Vector3(-44.1335, 218.334, -508.434), -- 555
	e_nl_over_1m_dwn_6m_roll = Vector3(-79.9646, 508.175, -504.713), -- 720
	e_nl_over_1m_dwn_7m = Vector3(-61.9238, 129.055, -701.948), -- 716
	e_nl_over_1m_dwn_8m = Vector3(3.84277, 295.79, -804.466), -- 857
	e_nl_over_1m_fwd_1_5m = Vector3(-0.827393, 237.467, 0.353161), -- 237
	e_nl_over_1m_jump_window = Vector3(-35.6873, 154.015, -1.01116), -- 158
	e_nl_over_2_3m = Vector3(-8.07617, 159.334, 0.440398), -- 159
	e_nl_over_2_4m = Vector3(-11.1089, 189.253, -100.572), -- 214
	e_nl_over_3_2m = Vector3(10.8945, 165.86, 99.4859), -- 193
	e_nl_over_3_35m = Vector3(10.3491, 131.487, 0.433899), -- 131
	e_nl_over_3m_fwd_2m_roll = Vector3(16.2173, 512.256, -0.706827), -- 512
	e_nl_over_3m_fwd_4m = Vector3(69.5771, 465.971, 1.40007), -- 471
	e_nl_over_4_25m = Vector3(17.6311, 273.314, 0.1245), -- 273
	e_nl_over_and_fwd_1m = Vector3(20.4697, 239.552, 5.74502), -- 240
	e_nl_over_and_fwd_1m_var2 = Vector3(38.321, 216.123, 15.0432), -- 220
	e_nl_plant_run_through = Vector3(13.6541, 174.366, 0.575007), -- 174
	e_nl_pool_jump = Vector3(24.4995, 609.96, -547.463), -- 819
	e_nl_press_button_enter = Vector3(-4.7749, 192.657, -0.734565), -- 192
	e_nl_run_jump_far_var1 = Vector3(36.9016, 805.421, -254.208), -- 845
	e_nl_run_jump_far_var2 = Vector3(46.3462, 831.873, -243.135), -- 867
	e_nl_run_jump_far_var3 = Vector3(78.6541, 998.838, -256.116), -- 1034
	e_nl_slide_4m_dwn_2m = Vector3(71.0222, 491.565, -201.303), -- 535
	e_nl_slide_down_2m = Vector3(10.1316, 206.559, -201.511), -- 288
	e_nl_slide_down_4m = Vector3(25.3618, 236.854, -400.572), -- 466
	e_nl_slide_fwd_4m = Vector3(-21.0698, 428.616, -1.59026), -- 429
	e_nl_ss_run_dunk_hood = Vector3(-90.2813, 655.234, -1.17896), -- 661
	e_nl_under_0_7m = Vector3(0.843506, 223.637, -0.947034), -- 223
	e_nl_up1m_fwd2m_through_window = Vector3(59.7644, 245.009, 96.4841), -- 270
	e_nl_up_0_25m_dwn_0_75m = Vector3(-0.337402, 274.625, -50.3611), -- 279
	e_nl_up_0_25m_dwn_5_75m = Vector3(-13.8315, 161.435, -546.467), -- 569
	e_nl_up_0_3m_dwn_13m = Vector3(5.84814, 255.047, -1292.45), -- 1317
	e_nl_up_0_3m_dwn_6_5m = Vector3(7.02222, 363.103, -639.422), -- 735
	e_nl_up_0_3m_dwn_6m = Vector3(4.77222, 256.075, -489.177), -- 552
	e_nl_up_0_3m_dwn_7m = Vector3(4.88672, 255.908, -694.049), -- 739
	e_nl_up_0_3m_dwn_9m = Vector3(0.918701, 255.711, -886.992), -- 923
	e_nl_up_0_5_down_4m_swing = Vector3(-4.71191, -6.35132, -453.932), -- 454
	e_nl_up_0_5_down_5_5m = Vector3(-10.4072, 230.595, -500.254), -- 550
	e_nl_up_0_5_down_5m_swing = Vector3(-18.4063, -243.922, -432.76), -- 497
	e_nl_up_0_5m_dwn_1m_window_out = Vector3(2.60864, 218.519, -44.9515), -- 223
	e_nl_up_0_5m_dwn_5_5m = Vector3(80.3921, 167.361, -503.382), -- 536
	e_nl_up_0_5m_dwn_9m = Vector3(5.07422, 255.651, -853.018), -- 890
	e_nl_up_0_5m_window_out = Vector3(-4.02539, 241.129, 24.6967), -- 242
	e_nl_up_0_75_dwn_1_75m = Vector3(12.1409, 244.051, -100.264), -- 264
	e_nl_up_0_75_dwn_1_75m_var2 = Vector3(4.47119, 266.854, -86.7605), -- 280
	e_nl_up_0_75m_dwn_0_25m = Vector3(28.4219, 250.362, 39.583), -- 255
	e_nl_up_0_7m = Vector3(7.16675, 129.89, 80.1258), -- 152
	e_nl_up_0_85_dwn_5_3m = Vector3(-8.44116, 237.046, -444.652), -- 503
	e_nl_up_0_8_down_1_25m = Vector3(5.05884, 244.352, -49.9815), -- 249
	e_nl_up_0_8_dwn_6_1m = Vector3(-55.1182, 278.053, -538.375), -- 608
	e_nl_up_0_8_dwn_6_1m_var2 = Vector3(-18.8093, 231.271, -538.836), -- 586
	e_nl_up_0_8m_down_2_3m = Vector3(0.0341797, 274.571, -150.458), -- 313
	e_nl_up_0_9m_dwn_1m_window_out = Vector3(2.13867, 239.054, 2.27302), -- 239
	e_nl_up_11_5m_down_1m = Vector3(-12.2422, 159.952, 1047.38), -- 1059
	e_nl_up_12m = Vector3(63.5657, 154.152, 1197.96), -- 1209
	e_nl_up_1_25_down_0_8m = Vector3(10.4746, 229.407, 49.3379), -- 234
	e_nl_up_1_3m = Vector3(13.3801, 77.8945, 125.741), -- 148
	e_nl_up_1_5_down_2_75m = Vector3(-9.2583, 459.706, -133.532), -- 478
	e_nl_up_1_5_down_3_4m = Vector3(-4.98413, 469.531, -185.55), -- 504
	e_nl_up_1_5m = Vector3(36.2654, 80.0713, 149.761), -- 173
	e_nl_up_1_5m_down_5m = Vector3(69.9045, 227.807, -407.873), -- 472
	e_nl_up_1_5m_dwn_0_8m = Vector3(-27.334, 250.34, 75.066), -- 262
	e_nl_up_1_5m_dwn_1m = Vector3(0.000244141, 277.059, 48.8728), -- 281
	e_nl_up_1_5m_dwn_3_5m = Vector3(-4.6062, 240.373, -234.027), -- 335
	e_nl_up_1_75_dwn_0_75m = Vector3(7.2063, 232.491, 100.67), -- 253
	e_nl_up_1_75m = Vector3(39.2197, 79.4482, 174.758), -- 195
	e_nl_up_1_down_13m = Vector3(-68.9512, 299.57, -1200.36), -- 1239
	e_nl_up_1_down_15_50m = Vector3(-15.1958, 290.945, -1524.1), -- 1551
	e_nl_up_1_down_3m = Vector3(-9.33838, 211.077, -200.234), -- 291
	e_nl_up_1_down_4_5m_drill = Vector3(-14.3037, 287.906, -332.831), -- 440
	e_nl_up_1_down_4_8m = Vector3(-14.3052, 287.85, -360.359), -- 461
	e_nl_up_1_down_5m = Vector3(-9.33838, 226.071, -400.24), -- 459
	e_nl_up_1_down_6_5m = Vector3(4.27002, 284.04, -578.514), -- 644
	e_nl_up_1_down_6m = Vector3(-12.5576, 235.719, -504.251), -- 556
	e_nl_up_1_down_6m_v2 = Vector3(67.2815, 152.534, -601.984), -- 624
	e_nl_up_1_down_6m_var3 = Vector3(3.51733, 299.321, -624.05), -- 692
	e_nl_up_1_down_7_1m = Vector3(67.2415, 195.812, -614.615), -- 648
	e_nl_up_1_down_8m = Vector3(-12.4023, 308.051, -726.542), -- 789
	e_nl_up_1_down_9m = Vector3(-69.342, 299.962, -800.362), -- 857
	e_nl_up_1_fwd_1_5m = Vector3(-5.50635, 409.522, -0.407445), -- 409
	e_nl_up_1_fwd_1_5m_var2 = Vector3(-12.3909, 471.798, -0.47386), -- 471
	e_nl_up_1m = Vector3(14.2312, 78.5586, 98.915), -- 127
	e_nl_up_1m_down_2_5m = Vector3(-12.4766, 232.618, -195.595), -- 304
	e_nl_up_1m_down_2m = Vector3(0, 275.508, -91.8981), -- 290
	e_nl_up_1m_down_4_3m_swing = Vector3(10.512, -33.1536, -325.22), -- 327
	e_nl_up_1m_down_4_5m = Vector3(-31.9529, 206.596, -360.505), -- 416
	e_nl_up_1m_down_4_5m_swing = Vector3(12.0071, -23.7747, -351.009), -- 352
	e_nl_up_1m_down_4_5m_var2 = Vector3(9.34595, 250.998, -350.461), -- 431
	e_nl_up_1m_down_4_5m_var3 = Vector3(56.5762, 181.363, -354.268), -- 401
	e_nl_up_1m_down_4m = Vector3(-14.4387, 224.26, -336.38), -- 404
	e_nl_up_1m_down_4m_window = Vector3(-48.3367, 192.631, -401.381), -- 447
	e_nl_up_1m_down_5m_swing = Vector3(16.9136, -17.6899, -395.883), -- 396
	e_nl_up_1m_dwn_0_5m_window_in = Vector3(4.23853, 245.628, 51.2281), -- 250
	e_nl_up_1m_dwn_0_9m_window_in = Vector3(24.0774, 230.405, 1.48553), -- 231
	e_nl_up_1m_dwn_18m = Vector3(-250.789, 183.752, -1693.94), -- 1722
	e_nl_up_1m_dwn_4_5m = Vector3(-14.4373, 224.192, -382.402), -- 443
	e_nl_up_1m_dwn_4_5m_roll = Vector3(-73.8779, 507.071, -381.232), -- 638
	e_nl_up_1m_dwn_4m = Vector3(-0.524902, 223.591, -299.279), -- 373
	e_nl_up_1m_dwn_4m_roll = Vector3(45.4583, 496.719, -306.297), -- 585
	e_nl_up_1m_dwn_6_5m = Vector3(-44.3723, 223.11, -554.068), -- 598
	e_nl_up_1m_dwn_9m = Vector3(5.0271, 255.705, -807.962), -- 847
	e_nl_up_1m_swing_dwn_3_5m = Vector3(12.8425, 20.3352, -350.692), -- 351
	e_nl_up_2_25_fwd_2_5_dwn_2_25m = Vector3(-37.3794, 515.526, -0.860758), -- 516
	e_nl_up_2_2_down_1m = Vector3(46.7051, 221.765, 121.811), -- 257
	e_nl_up_2_2m_down_2m = Vector3(47.0305, 224.383, 20.1568), -- 230
	e_nl_up_2_5m = Vector3(30.52, 125.308, 250.919), -- 282
	e_nl_up_2_5m_down_1m = Vector3(5.521, 249.581, 131.989), -- 282
	e_nl_up_2_5m_right_2m_jump = Vector3(-45.5771, 327.756, 195.005), -- 384
	e_nl_up_2_75_down_1_5m = Vector3(-0.0090332, 296.295, 134.575), -- 325
	e_nl_up_2_75_down_1m = Vector3(-12.0552, 158.087, 170.958), -- 233
	e_nl_up_2_75m = Vector3(11.3667, 133.746, 274.408), -- 305
	e_nl_up_2_9_dwn_0_8m = Vector3(45.8755, 216.226, 208.661), -- 303
	e_nl_up_2_down_8_2m = Vector3(-48.7954, 186.471, -620.595), -- 649
	e_nl_up_2m = Vector3(23.2205, 134.819, 197.528), -- 240
	e_nl_up_2m_down_1m = Vector3(46.7051, 221.765, 121.811), -- 257
	e_nl_up_2m_var4 = Vector3(0.0227051, 146.075, 199.072), -- 246
	e_nl_up_3_2m_down_1m = Vector3(-12.6013, 178.213, 209.273), -- 275
	e_nl_up_3_3m = Vector3(-17.0901, 136.149, 328.286), -- 355
	e_nl_up_3_4_down_1_5m = Vector3(23.2021, 291.471, 186.018), -- 346
	e_nl_up_3_5_dwn_1m = Vector3(27.7964, 543.377, 263.901), -- 604
	e_nl_up_3_5m = Vector3(-0.334473, 150.225, 350.013), -- 380
	e_nl_up_3_5m_dwn_1_5m = Vector3(-4.83887, 294.318, 234.695), -- 376
	e_nl_up_3_9m = Vector3(1.01196, 147.219, 392.219), -- 418
	e_nl_up_3_down_1m = Vector3(8.93994, 234.836, 192.891), -- 304
	e_nl_up_3m = Vector3(-0.542969, 186.705, 299.869), -- 353
	e_nl_up_3m_dwn_0_5m = Vector3(-16.7991, 128.112, 254.034), -- 285
	e_nl_up_3m_var2 = Vector3(-11.7734, 195.414, 299.976), -- 358
	e_nl_up_3m_var3 = Vector3(2.04932, 163.092, 278.784), -- 322
	e_nl_up_4_3m_dwn_1m = Vector3(28.644, 170.928, 331.551), -- 374
	e_nl_up_4_3m_dwn_1m_var2 = Vector3(-50.77, 229.017, 328.416), -- 403
	e_nl_up_4_4m_dwn_0_5m = Vector3(-43.3237, 271.832, 397.903), -- 483
	e_nl_up_4_5m_down_1m = Vector3(-5.76685, 382.861, 351.446), -- 519
	e_nl_up_4_5m_down_1m_var2 = Vector3(3.10693, 161.451, 358.638), -- 393
	e_nl_up_4_5m_down_1m_var3 = Vector3(-13.801, 280.225, 359.64), -- 456
	e_nl_up_4_6_down_0_6m = Vector3(33.9419, 149.488, 399.288), -- 427
	e_nl_up_4_8m = Vector3(95.6765, 210.319, 478.277), -- 531
	e_nl_up_4_down_1m_right = Vector3(85.7034, 245.208, 296.424), -- 394
	e_nl_up_4m = Vector3(-264.983, 308.95, 400.416), -- 570
	e_nl_up_4m_down_1m = Vector3(3.09619, 270.063, 329.96), -- 426
	e_nl_up_4m_var4 = Vector3(0.541016, 241.575, 399.549), -- 466
	e_nl_up_4m_wall_kick = Vector3(-8.84863, 152.792, 394.831), -- 423
	e_nl_up_5_5m = Vector3(25.4934, 286.296, 547.775), -- 618
	e_nl_up_5_5m_down_0_5m = Vector3(25.4148, 286.194, 497.627), -- 574
	e_nl_up_5_5m_down_1m = Vector3(-15.2883, 192.314, 400.391), -- 444
	e_nl_up_5_75m_dwn_0_25m = Vector3(68.1238, 146.656, 551.989), -- 575
	e_nl_up_5_75m_dwn_0_25m_var2 = Vector3(-84.7666, 149.091, 551.526), -- 577
	e_nl_up_5_down_1m = Vector3(-10.5232, 293.319, 399.633), -- 495
	e_nl_up_5_down_1m_right = Vector3(82.9722, 270.468, 398.722), -- 488
	e_nl_up_5_down_1m_var2 = Vector3(-5.67725, 278.67, 399.65), -- 487
	e_nl_up_5_dwn_1m_var3 = Vector3(11.937, 183.323, 406.893), -- 446
	e_nl_up_5m = Vector3(-290.6, 334.662, 507.846), -- 674
	e_nl_up_5m_1m_dwn_left_stairs = Vector3(-53.613, -42.7153, 401.938), -- 407
	e_nl_up_5m_1m_dwn_right_stairs = Vector3(101.556, -90.4219, 400.316), -- 422
	e_nl_up_6_2_down_1m = Vector3(118.298, -16.3584, 520.473), -- 533
	e_nl_up_6_2_down_1m_var2 = Vector3(-41.5989, 151.196, 519.389), -- 542
	e_nl_up_6_2_down_1m_var3 = Vector3(-52.7839, 186.115, 596.87), -- 627
	e_nl_up_6_down_1m_right = Vector3(82.9231, 253.876, 490.303), -- 558
	e_nl_up_6m = Vector3(-144.982, -14.6775, 600.008), -- 617
	e_nl_up_6m_var2 = Vector3(191.987, 143.353, 597.24), -- 643
	e_nl_up_6m_var3 = Vector3(63.6067, 144.308, 600.36), -- 620
	e_nl_up_7_5m_down_1m = Vector3(-13.0103, 148.189, 646.368), -- 663
	e_nl_up_7_down_1m = Vector3(53.0076, 106.171, 599.992), -- 611
	e_nl_up_7_down_1m_var2 = Vector3(55.3254, 475.327, 601.668), -- 768
	e_nl_up_7m_ladder = Vector3(7.03491, 179.674, 645.38), -- 669
	e_nl_up_8m_dwn_0_8m_left = Vector3(-66.3093, 164.229, 725.962), -- 747
	e_nl_up_8m_left_2m_over_1m = Vector3(-109.407, -226.487, 802.405), -- 840
	e_nl_up_8m_right_2m_over_1m = Vector3(410.813, 174.328, 797.236), -- 913
	e_nl_up_9_down_1m = Vector3(141.698, 152.611, 798.597), -- 825
	e_nl_up_elevator_shaft = Vector3(63.9509, 335.476, 355.025), -- 492
	e_nl_up_ladder_2_5m = Vector3(-33.7019, 123.279, 255.399), -- 285
	e_nl_up_ladder_4m = Vector3(1.27319, 95.9448, 388.659), -- 400
	e_nl_up_ladder_4m_left_exit = Vector3(-93.2793, 66.0151, 396.851), -- 412
	e_nl_up_rats_roof = Vector3(85.9395, 46.7024, 922.734), -- 927
	e_nl_window_climb_up_4m = Vector3(31.4753, 61.6982, 401.544), -- 407
	e_nl_window_climb_up_8m = Vector3(8.30688, 20.7202, 792.523), -- 792
	e_nl_zipline_glace = Vector3(3941.86, 72.1992, -632.596), -- 3992
	e_so_balloon = Vector3(53.51, -102.266, 0.371557), -- 115
	e_so_balloon_var2 = Vector3(45.1172, -100.374, 0.33928), -- 110
	e_so_barn_door_open_r = Vector3(-308.012, -370.211, 0.413982), -- 481
	e_so_blindfire_exit = Vector3(99.0935, 30.5659, -0.368579), -- 103
	e_so_climb_up_out_3m = Vector3(11.3391, 281.717, 73.5099), -- 291
	e_so_crawl_vent_berry = Vector3(186.075, 668.181, 2.69601), -- 693
	e_so_des_walk_exit = Vector3(410.772, -641.067, 1.42084), -- 761
	e_so_down_stairs_5m = Vector3(-17.9087, 374.215, -402.469), -- 549
	e_so_exit_car_hood = Vector3(32.5938, 82.3018, -79.8799), -- 119
	e_so_exit_car_hood_var2 = Vector3(131.085, 693.732, 2.24858), -- 706
	e_so_exit_cover_l = Vector3(-98.5706, 29.5237, -0.278509), -- 102
	e_so_exit_speech = Vector3(5.50977, 74.5615, -101.735), -- 126
	e_so_investigate_truck = Vector3(21.3633, 627.794, 100.932), -- 636
	e_so_investigate_truck_slope = Vector3(16.1545, 628.025, 16.5983), -- 628
	e_so_ntl_open_door_in = Vector3(0.0949707, 242.674, 0.617642), -- 242
	e_so_ntl_open_door_out = Vector3(8.927, 154.8, 0.409714), -- 155
	e_so_ntl_run_push_door = Vector3(-4.56592, 240.179, 0.670232), -- 240
	e_so_open_container = Vector3(-0.181152, -97.4514, 0.28564), -- 97
	e_so_plant_c4_floor = Vector3(-13.5076, -93.7837, -0.0405626), -- 94
	e_so_plant_c4_hi = Vector3(108.448, -108.47, -0.563335), -- 153
	e_so_react_var1 = Vector3(-99.4368, -43.208, 0.128917), -- 108
	e_so_run_long_l = Vector3(-2437.1, 736.382, 7.00802), -- 2545
	e_so_run_long_r = Vector3(2375.21, 810.194, -12.9046), -- 2509
	e_so_run_short_l = Vector3(-1266.41, 983.403, 1.28065), -- 1603
	e_so_run_short_r = Vector3(1214.19, 1007.55, -8.9746), -- 1577
	e_so_sit_cigar_exit = Vector3(87.946, -84.7427, -0.064017), -- 122
	e_so_sit_drink_exit = Vector3(92.9905, -80.7288, -0.0154891), -- 123
	e_so_stand_back_to_crouch = Vector3(-1.46753, -113.34, 0.144418), -- 113
	e_so_teleport_var1 = Vector3(0.16333, -2527.64, 7259.86), -- 7687
	e_so_teleport_var2 = Vector3(-4500.05, 5178.59, -44972.4), -- 45492
	e_so_teleport_var3 = Vector3(-3965.43, -945.609, -44964.6), -- 45149
	e_so_tube_interact = Vector3(-0.187744, -100.9, 0.295742), -- 100
	e_so_up_dwn_car_hood = Vector3(112.603, 697.808, 2.0968), -- 706
	e_so_up_stairs_5m = Vector3(-1.22388, 318.366, 401.27), -- 512
	e_so_walk_investigate = Vector3(-6.36646, 475.792, 0.686619), -- 475
	e_so_walk_investigate_unarmed = Vector3(-6.3689, 475.79, 0.686495), -- 475
	e_sp_back_to_floor_2 = Vector3(936.935, 42.8384, 1.11297), -- 937
	e_sp_back_to_floor_3 = Vector3(688.897, 50.2874, 1.87041), -- 690
	e_sp_back_to_roof = Vector3(551.593, 63.3984, 3.10751), -- 555
	e_sp_barn_door_open_l = Vector3(316.733, -347.134, 1.65941), -- 469
	e_sp_barn_door_open_r = Vector3(-307.941, -370.157, 0.414611), -- 481
	e_sp_boat_stairs_var1 = Vector3(110.098, -75.9226, 0.450912), -- 133
	e_sp_boat_stairs_var3 = Vector3(-65.7109, -53.2874, 3.61848), -- 84
	e_sp_climb_up_bridge = Vector3(11.4873, -16.7527, 522.421), -- 522
	e_sp_dizzy_walk_left = Vector3(11.5015, 266.41, -0.653415), -- 266
	e_sp_dizzy_walk_right = Vector3(15.9321, 314.349, -0.782559), -- 314
	e_sp_fight_looser_l = Vector3(-139.08, -118.262, 1.57564), -- 182
	e_sp_fight_looser_r = Vector3(69.4919, 268.504, -2.54294), -- 277
	e_sp_fight_winner = Vector3(-207.216, 160.074, -0.718992), -- 261
	e_sp_hurt_from_truck = Vector3(70.1465, 290.894, -0.215996), -- 299
	e_sp_kick = Vector3(30.7688, 158.559, -0.387196), -- 161
	e_sp_kick_enter = Vector3(-9.47974, 271.21, -0.806399), -- 271
	e_sp_kicked = Vector3(15.0627, -182.934, -0.765972), -- 183
	e_sp_left_to_floor_1 = Vector3(59.3198, 574.593, 3.57917), -- 577
	e_sp_left_to_floor_1_3_4_var2 = Vector3(12.4321, 237.969, 1.73895), -- 238
	e_sp_left_to_floor_2 = Vector3(37.1111, 857.201, 1.19629), -- 858
	e_sp_left_to_floor_2_var2 = Vector3(25.0044, 629.72, 3.99307), -- 630
	e_sp_left_to_floor_3 = Vector3(24.6252, 671.753, 3.43933), -- 672
	e_sp_left_to_floor_4 = Vector3(40.6382, 693.302, 4.05554), -- 694
	e_sp_right_to_floor_2 = Vector3(1364.74, 564.527, 5.65879), -- 1476
	e_sp_right_to_floor_2_var2 = Vector3(966.187, 485.411, 5.30672), -- 1081
	e_sp_right_to_floor_3 = Vector3(1270.02, 1229.48, 6.12329), -- 1767
	e_sp_right_to_floor_3_var2 = Vector3(910.308, 837.583, 6.07235), -- 1237
	e_sp_right_to_floor_4 = Vector3(1419.17, 876.814, 8.49927), -- 1668
	e_sp_right_to_floor_4_var2 = Vector3(732.58, 532.28, 4.86374), -- 905
	e_sp_right_to_roof = Vector3(1374.11, 329.439, 6.55771), -- 1413
	e_sp_ss_exitcar_right = Vector3(98.6763, 0.810547, 0.127928), -- 98
	e_up_1m_down_3m = Vector3(-257.357, -61.7278, -296.667), -- 397
	gen_stun_conc_shield = Vector3(-102.432, -44.814, 0.133211), -- 111
}

function Iter:get_navlink_vector(so_action, rotation)
	local vbase = so_action and self.navlengths[so_action]
	if not vbase then
		return false
	end

	local result = Vector3()
	mvector3.set(result, vbase)
	mvector3.rotate_with(result, rotation)
	return result
end

if not Iter.settings.rebuild_navlinks then
	return
end

local itr_original_elementspecialobjective_finalize_values = ElementSpecialObjective._finalize_values
function ElementSpecialObjective:_finalize_values(values)
	if values.is_navigation_link and values.position and values.search_position and values.rotation then
		local nlv = Iter:get_navlink_vector(values.so_action, values.rotation)
		if nlv then
			mvector3.add(nlv, values.position)

			local tracker = managers.navigation:create_nav_tracker(nlv, true)
			local pos_on_field = tracker:field_position()
			local same_idseg = tracker:nav_segment() == managers.navigation:get_nav_seg_from_pos(values.search_position, true)
			managers.navigation:destroy_nav_tracker(tracker)

			if same_idseg or mvector3.distance(values.search_position, pos_on_field) > 200 then
				values.search_position = pos_on_field
			end
		end
	end

	return itr_original_elementspecialobjective_finalize_values(self, values)
end
