local key = ModPath .. '	' .. RequiredScript
if _G[key] then return else _G[key] = true end

_G.Marking = Marking or {}
Marking.path = ModPath
Marking.data_path = SavePath .. 'marking.txt'
Marking.settings = {
	mark_aim = true,
	ignore_disabled_cams = true,
	prioritize_intimidated = true,
	disable_sentry_switch_fire_mode = false,
}

local original_sentry_gun_fire_mode_max_interact_distance = tweak_data.interaction.sentry_gun_fire_mode.max_interact_distance
function Marking:update_sentry_gun_fire_mode()
	local sgfm = tweak_data.interaction.sentry_gun_fire_mode
	if self.settings.disable_sentry_switch_fire_mode then
		sgfm.max_interact_distance = sgfm.interact_distance + 1
	else
		sgfm.max_interact_distance = original_sentry_gun_fire_mode_max_interact_distance
	end
end

function Marking:load()
	local file = io.open(self.data_path, 'r')
	if file then
		for k, v in pairs(json.decode(file:read('*all')) or {}) do
			self.settings[k] = v
		end
		file:close()
	end
	self:update_sentry_gun_fire_mode()
end

function Marking:save()
	local file = io.open(self.data_path, 'w+')
	if file then
		file:write(json.encode(self.settings))
		file:close()
	end
end

Marking:load()

Hooks:Add('LocalizationManagerPostInit', 'LocalizationManagerPostInit_Marking', function(loc)
	local language_filename

	local modname_to_language = {
		['PAYDAY 2 THAI LANGUAGE Mod'] = 'thai.txt',
	}
	for _, mod in pairs(BLT and BLT.Mods:Mods() or {}) do
		language_filename = mod:IsEnabled() and modname_to_language[mod:GetName()]
		if language_filename then
			break
		end
	end

	if not language_filename then
		for _, filename in pairs(file.GetFiles(Marking.path .. 'loc/')) do
			local str = filename:match('^(.*).txt$')
			if str and Idstring(str) and Idstring(str):key() == SystemInfo:language():key() then
				language_filename = filename
				break
			end
		end
	end

	if language_filename then
		loc:load_localization_file(Marking.path .. 'loc/' .. language_filename)
	end
	loc:load_localization_file(Marking.path .. 'loc/english.txt', false)
end)

Hooks:Add('MenuManagerInitialize', 'MenuManagerInitialize_Marking', function(menu_manager)
	MenuCallbackHandler.MarkingMenuCheckboxClbk = function(this, item)
		Marking.settings[item:name()] = item:value() == 'on'
		Marking:update_sentry_gun_fire_mode()
	end

	MenuCallbackHandler.MarkingSave = function(this, item)
		Marking:save()
	end

	MenuHelper:LoadFromJsonFile(Marking.path .. 'menu/options.txt', Marking, Marking.settings)
end)

local mrk_original_playerstandard_getinteractiontarget = PlayerStandard._get_interaction_target
function PlayerStandard:_get_interaction_target(char_table, ...)
	local settings = Marking.settings
	for i = #char_table, 1, -1 do
		local item = char_table[i]
		local unit_type = item.unit_type

		if unit_type == 0 and settings.prioritize_intimidated then -- unit_type_enemy
			local anim_data = item.unit:anim_data()
			if anim_data.hands_up or anim_data.hands_back then
				item.inv_wgt = item.inv_wgt * 0.3
			end

		elseif unit_type == 3 and settings.ignore_disabled_cams then -- unit_type_camera
			if type(item.unit.interaction) == 'function' and type(item.unit:interaction()) == 'table' and item.unit:interaction():active() then
				-- qued
			else
				table.remove(char_table, i)
			end
		end
	end

	return mrk_original_playerstandard_getinteractiontarget(self, char_table, ...)
end

if Marking.settings.mark_aim then
	local mvec3_add = mvector3.add
	local mvec3_mul = mvector3.multiply
	local mvec3_norm = mvector3.normalize
	local mvec3_set = mvector3.set
	local mvec3_sub = mvector3.subtract

	local tmp_interact_vec1 = Vector3()
	local tmp_interact_vec2 = Vector3()

	function PlayerStandard:_add_unit_to_char_table(char_table, unit, unit_type, interaction_dist, interaction_through_walls, tight_area, priority, my_head_pos, cam_fwd, ray_ignore_units, ray_types)
		if unit:unit_data().disable_shout and not unit:brain():interaction_voice() then
			return
		end

		local u_head_pos = tmp_interact_vec1
		if unit_type == 3 then
			unit:base():get_mark_check_position(u_head_pos)
		else
			mvec3_set(u_head_pos, unit:movement():m_head_pos())
			mvec3_set(tmp_interact_vec2, math.UP)
			mvec3_mul(tmp_interact_vec2, 30)
			mvec3_add(u_head_pos, tmp_interact_vec2)
		end

		local vec = tmp_interact_vec2
		mvec3_set(vec, u_head_pos)
		mvec3_sub(vec, my_head_pos)

		local dis = mvec3_norm(vec)

		local max_dis = interaction_dist
		if not max_dis or dis < max_dis then
			local max_angle = math.max(8, math.lerp(tight_area and 30 or 90, tight_area and 10 or 30, dis / 1200))
			local angle = vec:angle(cam_fwd)
			if angle < max_angle then
				if interaction_through_walls then
					table.insert(char_table, {
						unit = unit,
						inv_wgt = angle,
						unit_type = unit_type
					})
				else
					local ray = World:raycast('ray', my_head_pos, u_head_pos, 'slot_mask', self._slotmask_AI_visibility, 'ray_type', ray_types or 'ai_vision', 'ignore_unit', ray_ignore_units or {})
					if not ray or mvector3.distance_sq(ray.position, u_head_pos) < 900 then
						table.insert(char_table, {
							unit = unit,
							inv_wgt = angle,
							unit_type = unit_type
						})
					end
				end
			end
		end
	end
end
