SavefileManager.AMOUNT_OF_SLOTS = 9
SavefileManager.DEFAULT_SLOT = SavefileManager.PROGRESS_SLOT
SavefileManager.MOD_SAVE = SavePath .. "SavefileManager.json"
SavefileManager.settings = io.file_is_readable(SavefileManager.MOD_SAVE) and io.load_as_json(SavefileManager.MOD_SAVE) or {}
SavefileManager.settings.save_slot = SavefileManager.settings.save_slot or 1
SavefileManager.slot_items = {}

for i = 1, SavefileManager.AMOUNT_OF_SLOTS do
	table.insert(SavefileManager.slot_items, "slot_" .. i)
end

if Global._current_save_slot then
	SavefileManager.PROGRESS_SLOT = Global._current_save_slot
else
	SavefileManager.PROGRESS_SLOT = SavefileManager.DEFAULT_SLOT - (SavefileManager.settings.save_slot - 1)
	Global._current_save_slot = SavefileManager.PROGRESS_SLOT
end
SavefileManager.BACKUP_SLOT = SavefileManager.PROGRESS_SLOT

Hooks:Add("MenuManagerBuildCustomMenus", "MenuManagerBuildCustomMenusSavefileManager", function(menu_manager, nodes)
	local locs = {
		menu_savefile_manager = "Savefile Manager",
		menu_savefile_manager_save_slot = "Save Slot",
		menu_savefile_manager_save_slot_desc = "Save slot to use",
	}
	for i, v in ipairs(SavefileManager.slot_items) do
		locs[v] = "Save Slot " .. i
	end
	managers.localization:add_localized_strings(locs)

	function MenuCallbackHandler:SavefileManager_set_slot(item)
		SavefileManager.settings[item:name()] = item:value()
	end

	function MenuCallbackHandler:SavefileManager_apply_slot()
		io.save_as_json(SavefileManager.settings, SavefileManager.MOD_SAVE)

		if SavefileManager.settings.save_slot == Global._current_save_slot - SavefileManager.DEFAULT_SLOT + 1 then
			return
		end

		local buttons = {
			{
				text = "Yes",
				callback = function ()
					os.execute("start steam://rungameid/218620")
					os.exit()
				end
			},
			{
				text = "No"
			},
		}
		QuickMenu:new("Information", "Save slot has been changed to slot " .. SavefileManager.settings.save_slot .. ".\nA restart is required for the change take effect.\nDo you want to restart the game now?", buttons, true)
	end

	local menu_id = "SavefileManager"
	MenuHelper:NewMenu(menu_id)

	MenuHelper:AddMultipleChoice({
		id = "save_slot",
		title = "menu_savefile_manager_save_slot",
		desc = "menu_savefile_manager_save_slot_desc",
		callback = "SavefileManager_set_slot",
		value = SavefileManager.settings.save_slot,
		items = SavefileManager.slot_items,
		menu_id = menu_id
	})

	nodes[menu_id] = MenuHelper:BuildMenu(menu_id, { back_callback = "SavefileManager_apply_slot" })

	MenuHelper:AddMenuItem(nodes["blt_options"], menu_id, "menu_savefile_manager")
end)
