# SuperBLT Basemod Changelog

This lists the changes between different versions of the SuperBLT basemod,
the changes for the DLL are listed in their own changelog.
Contributors other than maintainers are listed in parenthesis after specific changes.

## v1.4.7

- Added JSON parser for Wren (.ruby)
- Disabled loading of supermod.xml files when a mod is disabled due to VR/Desktop mode (test1)
- Fixed mods having to be manually re-enabled after a missing dependency was installed

## v1.4.6

- Fixed a crash in the mod search box
- Fixed an oversight in Hooks:OverrideFunction

## v1.4.5

- Improved developer annotations
- Updated Korean localization (BrainInAVet)
- Added mod profiles to quickly toggle groups of mods
- Added notifications for mods that require a full restart

## v1.4.4

- Fixed a network receive hooks crash

## v1.4.3

- Improved networking utility functions
- Added network receive hooks
- Added search box to BLT mod list

## v1.4.2

- Fixed an oversight with the previous update

## v1.4.1

- Updated Russian localization (HarGabt)
- Updated Polish localization (Patriot)
- Updated Czech localization (vojin154)
- Fixed minor code oversights
- Fixed Hooks:Remove not working

## v1.4.0

- Fixed some utility functions that were using outdated code
- Improved BLT logging (Vadim)
- Fixed mod patchnotes button crashing on Epic
- Improved update and dependency checking

## v1.3.9

- Updated German localization
- Fixed a potential issue with return values in Hooks
- Changed download progress to show in KB or MB if appropriate

## v1.3.8

- Updated Simplified Chinese localization (act2498)
- Updated Czech localization (vojin154)
- Updated Spanish localization (ElCabe99)
- Updated MenuHelper documentation
- Added additional parameters for slider and multi choice menu items (see documentation)
- Fixed mod UI resetting its settings occasionally
- Added additional utility functions to UtilsCore

## v1.3.7

- Added functionality for setting minimum and maximum sound distance on XAudio sources
- Added separate BLT save file for VR and functionality for mod authors to mark their mods as desktop/VR only
- Moved BLT language setting to dedicated BLT settings menu and added settings for logging

## v1.3.6

This is a hotfix including a fix for a critical issue with the upcoming heist release

- Fixed an oversight in the Xaudio listener that would crash the game
- Fixed menu location for SuperBLT's mod options menu

## v1.3.5

- Improved error handling for json decoding
- Added functionality to get return values in hooks
- Added Czech translation (Dom)
- Updated Spanish translation (ElCabe99)
- Re-implemented mod dependencies
- Improved download manager and BLT mod UI
- Added and improve utility functions (Krimzin)
- Added documentation annotations

## v1.3.4

- Fixed a potential issue in the GetModOwnerOfFile function (Dot Net)
- Optimized the XAudio update loop (Dom)
- Improved and fix crashes in BLTNotificationsManager
- Added Korean localization (BrainInAVet)

## v1.3.3

- Fixed undefined behavior with nested DelayedCalls
- Improved the localization macro system to handle macro replacements properly
- Improved the Hooks system and add new functionality
- Fixed potential crash with files not generated by BLT in the logs directory
- Fixed slider menu elements always being localized

## v1.3.1

- Added the XMl tweaker control keys system
- Added the Wren AssetUtil API class for asset overriding with better cross-mod compatibility
- Fixed delayed calls losing their ids on update
- Allowed mods to alter their Wren 'base' directory
- Implement better Wren error handling, showing a popup rather than crashing if a mod failed to load

## v1.3.0

This version never ended up shipping and was incorporated into v1.3.1.

- Fixed BLT:GetOS() returning "linux" on Windows under specific conditions
- Made the parsing code for `supermod.xml` more tolerant of malformed input, so future tags won't crash older versions
- Added BLT:Log function, supporting logging levels
- Updated the Wren system to use the new features added in the DLL
- Removed the wren TweakRegistry
- Disabled Wren-related functionality for disabled mods
- Made MenuHelper return created menu items
- Updated the Brazilian Portuguese translation (Gabriel F)
- Made SuperBLT load XML tweaks from `mod_overrides` mods, to store animations there (Cpone)
- Fixed calls with invalid values crashing `XAudio.Source:set_volume`
- Updated the Chinese translation (SummonHIM)
- Added a Japanese translation (Takuya Namba)
- Added autoupdate support for renamed mod folders (TdlQ)
- Fixed mods with dependencies on other mods using the paydaymods.com update system being disabled due to missing dependencies

## v1.2.0

Note that I forgot to update the version number for this one, so it looked like you were on v1.1.6.0 from the mods menu.

- Fixed Hooks:PreHook and Hooks:PostHook discarding multiple returns
- Fixed JSON files that decode to `null` or `""` crashing the game (DorentuZ)
- Made the JSON parser accept some JSON5-like extensions, such as trailing commas and comments (DorentuZ)
- Fixed wren `XML.is_element` crashing if the node's name is two characters or less
- Updated French translations (Brskt)
- Added a Brazilian Portuguese translation (Gabriel F)
- Fixed the language selector switching back to English (Luffyyy)
- Removed support for paydaymods.com updates, since the site is gone (Luffyyy)
- Fixed removing keybinds not being saved (steam-test1)
- Fixed crash-causing bugs in Hooks:PreHook and Hooks:PostHook (DorentuZ)
- Added BLTModManager:GetModByName (Luffy)
- Added mod.txt version number checking to the autoupdater, in addition to hash-based checking (Luffyyy)
- Fixed the debug information from supermod.xml assets showing the wrong path
- Disabled converting old pre-LuaJIT BLT savefiles (steam-test1)
- Added a Dutch translation (DorentuZ)

## v1.1.6.0

- Added Polish translation (Alister The Hedgehog)
- Fixed the BLT menus not appearing after update 198 (Luffy)
- Added macro support for custom localisations (DorentuZ)
- Fixed not being able to unbind keybinds (Offyerrocker)
- Removed misleading `blt_version` check, with the intention of later adding a minimum version field (Luffy)
- Added an initial BLT asset manager, allowing the use of recoding Windows assets for Linux
- Fixed entry scripts running when their mod is disabled
- Fixed dependency checks for long chains (TdlQ)
- Fixed the XML tweaker appending nodes in reverse order (Snh20)
- Added error details to the XML tweaker (Snh20)
- Disabled loading native modules for a disabled mod

## v1.1.5.1

- Improved formatting of the supermod.xml unknown tag name error
- Added error logging for errors encountered during asset loading
- Added automatic XML asset conversion
- Disabled asset loading for a disabled mod
- Added non-localized description support for menu items (Ludor)
- Don't apply an tweak multiple times under some conditions

## v1.1.5.0

- Added graphical indications in the mod manager and mod info pages about the progress of mod update checking
- Fixed mod updates with invalid URLs from getting stuck on the update check
- Block updates for mods under version control, to prevent developers' work from being deleted by accidentally updating
- Added hide mod icons and hide libraries options to the mod manager
- Fixed wildcard scripts crashing when run
- Added BLTCustomComponent (Luffy)
- Added MenuHelper:AddComponent
- Corrected grammar in the Swedish translation (BreakinBenny)
- Added Wren-based native module loading support
- Added entry scripts
- Added native module loading support
- Added exists function for custom localizations

## v1.1.4.2

- Added automatic update support for the WSOCK32.dll hook option on Windows

## v1.1.4.1

- Fixed dependency downloading
- Corrected the XAudio world scale so stuff sounds the correct distance away

## v1.1.4.0

- Fixed persist scripts
- When a player is not available, use the camera for correct audio positioning
- Added option to XAudioSource to allow music playback while the game is paused
- Added Swedish translation (BreakinBenny)

## v1.1.3.1

- Fixed mod options not appearing in VR

## v1.1.3.0

- When available, use asynchronous hashing to vastly reduce the freeze when update data is received
- Improved loading times for the mod menu icons
- Added warning when assets have failed to load
- Added debugging mode to asset loader

## v1.1.2.0

- Don't run custom assets through the XML tweak system
- Added `AssetLoader:FreeAssetGroup` method, allowing mods to unload assets they have loaded

## v1.1.1.0

- Fixed `mod:GetSuperMod()` always returning `nil`
- Fixed custom update metadata being set to the wrong tag
- Sorted mod options alphabetically
- Prevent persist scripts from running if their parent mod is disabled
- Allow mouse wheel movements to be used for mod keybinds (TdlQ, BangL)
- Improved `Utils:GetCrosshairRay()` to be more reliable and fix several crash bugs (TdlQ, BangL)
- Fixed file locking on Windows causing mods to be deleted instead of updated (TdlQ, BangL)
- Fixed crashing when toggling fullscreen
- Added a getter to the BLTMod class to get the asset loader instance
- Added the global ModInstance variable, similar to ModPath
- Added substitution functionality to `supermod.xml` properties
- Clean up the `base_path` functionality of the asset loader

## v1.1.0.0

- Added XML-based Lua hook support, as an alternative to the `hooks` tag in `mod.txt`
- Improved error reporting in `supermod.xml`
- Added the SuperBLT asset loader

## v1.0.2.1

- Updated details in `mod.txt` list it as SuperBLT rather than vanilla BLT

## v1.0.2.0

- Create downloads, logs and saves directories on startup if they are missing
- Moved temporary directory for mod downloads to the downloads folder
- Fixed `XAudioSource:is_relative` being named `is_looping`

## v1.0.1.0

- Added `relative` and `looping` properties to `XAudioSource`

## v1.0.0

- Added XAudio API
- Added custom updates system
- Added the XML Tweaker, and it's `supermod.xml` file
