local zdann = "zdann"
local zdann_hashlito = zdann:id()
local MassUnit = getmetatable(MassUnitManager)
local Wrld = getmetatable(World)
local App = getmetatable(Application)
local mat_ids = Idstring("material")
local diffuse_ids = Idstring("diffuse_texture")
local normal_ids = Idstring("normal")
local done = {}

DB:create_entry(Idstring("texture"), zdann, ModPath.."zdann.png")
DB:create_entry(Idstring("movie"), zdann, ModPath.."zdann.bik")

Wrld._orig_spawn_unit = Wrld._orig_spawn_unit or Wrld.spawn_unit
MassUnit._orig_spawn_unit = MassUnit._orig_spawn_unit or MassUnit.spawn_unit

App.set_material_texture_corrupt = App.set_material_texture_corrupt or App.set_material_texture
function App:set_material_texture() end

local function spawn_unit(self, ...)
	local unit = self:_orig_spawn_unit(...)
	if not done[unit:name():key()] then
		done[unit:name():key()] = true
		for _, material in pairs(unit:get_objects_by_type(mat_ids)) do
			Application:set_material_texture_corrupt(material, diffuse_ids, zdann_hashlito, normal_ids)
		end
	end
	return unit
end

Wrld.spawn_unit = spawn_unit
MassUnit.spawn_unit = spawn_unit

local ws_panel = Overlay:gui():create_scaled_screen_workspace(10, 10, 10, 10, 10):panel()
local Panel = getmetatable(ws_panel:panel())
local Bitmap = getmetatable(ws_panel:bitmap({w = 0}))
Overlay:newgui():destroy_workspace(ws_panel)

Panel._orig_bitmap = Panel._orig_bitmap or Panel.bitmap
local not_allowed = {
	["guis/textures/mouse_pointer"] = true,
	["guis/textures/pd2/hud_corner"] = true,
	["guis/textures/menu_tickbox"] = true
}
function Panel:bitmap(params, ...)
	local tex = params.texture
	if not not_allowed[tex] then
		params.texture = zdann
	end
	return self:_orig_bitmap(params, ...)
end

Bitmap._orig_set_image = Bitmap._orig_set_image or Bitmap.set_image
function Bitmap:set_image(tex, ...)
	if not not_allowed[tex] then
		tex = zdann
	end
	self:_orig_set_image(tex, ...)
end

Panel._orig_video = Panel._orig_video or Panel.video
function Panel:video(params, ...)
	params.video = zdann
	return self:_orig_video(params, ...)
end

local REPLACED_FUCKER
Hooks:Add("GameSetupUpdate", "Zdann", function(t, dt)
    if not REPLACED_FUCKER and Underlay:loaded() then
        local material = Underlay:material(Idstring("sky"))
        if material then
            Application:set_material_texture_corrupt(material, diffuse_ids, zdann_hashlito, normal_ids)
            REPLACED_FUCKER = true
        end
    end
end)